/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.invoke.SerializedLambda;
import org.codefilarete.reflection.AbstractMutator;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.MethodReferences;
import org.codefilarete.reflection.ValueAccessPointByMethodReference;
import org.codefilarete.tool.Reflections;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;

public class MutatorByMethodReference<C, T>
extends AbstractMutator<C, T>
implements ValueAccessPointByMethodReference<C> {
    private final SerializableBiConsumer<C, T> methodReference;
    private final String methodReferenceSignature;
    private final String methodName;
    private final Class declaringClass;
    private final SerializedLambda serializedLambda;
    private final Class propertyType;

    public MutatorByMethodReference(SerializableBiConsumer<C, T> methodReference) {
        this.methodReference = methodReference;
        this.serializedLambda = MethodReferences.buildSerializedLambda(methodReference);
        this.methodName = this.serializedLambda.getImplMethodName();
        this.declaringClass = MethodReferences.giveImplementingClass(this.serializedLambda);
        this.propertyType = MethodReferenceCapturer.giveArgumentTypes(this.serializedLambda).getArgumentTypes()[0];
        this.methodReferenceSignature = Reflections.toString((Class)this.declaringClass).concat("::").concat(this.methodName);
    }

    public SerializableBiConsumer<C, T> getMethodReference() {
        return this.methodReference;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<C> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public SerializedLambda getSerializedLambda() {
        return this.serializedLambda;
    }

    @Override
    protected void doSet(C c, T t) {
        this.methodReference.accept(c, t);
    }

    @Override
    protected String getSetterDescription() {
        return this.methodReferenceSignature;
    }

    @Override
    public Class<T> getPropertyType() {
        return this.propertyType;
    }
}

